<?php

use App\Http\Controllers\Authorization\AuthorizationChecker;
use App\Models\Authorization\AuthorizationDependency;
use App\Models\Authorization\AuthorizationLevel;
use App\Models\Authorization\AuthorizationPermission;
use App\Models\Plugins\Advertisement;
use App\Models\Plugins\Credits\PointSettings;
use App\Models\Plugins\Credits\PointTransaction;
use App\Models\Plugins\Credits\UserPoint;
use App\Models\Plugins\Geo\City;
use App\Models\Plugins\Geo\Country;
use App\Models\Plugins\Geo\State;
use App\Models\Plugins\MenuBuilder\Page;
use App\Models\User;
use Artesaos\SEOTools\Facades\OpenGraph;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Facades\SEOTools;
use Carbon\Carbon;
use GeoIp2\Database\Reader;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Intervention\Image\Drivers\Gd\Driver;
use Intervention\Image\ImageManager;
use Stichoza\GoogleTranslate\GoogleTranslate;

if (! function_exists('makeImage')) {
    function makeImage($data, string $path, array $size = [200, 200])
    {
        $image = str_replace('data:image/png;base64,', '', $data);
        $image = str_replace(' ', '+', $image);
        $name = Str::uuid().'.'.'png';
        $dir = checkDir($path).'/'.$name;
        $manager = new ImageManager(new Driver);
        $manager->read(base64_decode($image))->cover($size[0], $size[1])->save(storage_path('app/public/'.$dir));

        return 'storage/'.$dir;
    }
}

if (! function_exists('cropImage')) {
    function cropImage(Request $request, string $source, string $path, array $size = [600, 360])
    {
        if ($request->hasFile($source)) {
            $file = $request->file($source);
            $manager = new ImageManager(new Driver);
            $image = $manager->read($file);
            $image->cover($size[0], $size[1]);
            $name = Str::uuid().'.'.$file->getClientOriginalExtension();
            $dir = checkDir($path).'/'.$name;
            $image->save(storage_path('app/public/'.$dir));

            return 'storage/'.$dir;
        } else {
            return 'default.png';
        }
    }
}
if (! function_exists('makeWebp')) {
    function makeWebp(Request $request, string $source, string $path, int $width = 1000, int $quality = 70)
    {
        if ($request->hasFile($source)) {
            $name = Str::uuid().'.webp';
            $dir = checkDir($path).'/'.$name;

            $manager = new ImageManager(new Driver);
            $image = $manager->read($request->file($source));
            $image->resizeDown($width, $width * 0.75);
            $image->toWebp($quality)->save(storage_path('app/public/'.$dir));

            return 'storage/'.$dir;
        } else {
            return 'default.png';
        }
    }
}

if (! function_exists('storeFile')) {
    function storeFile(Request $request, string $source = 'avatar', string $path = 'avatars')
    {
        $files = $request->file($source);
        $dir = checkDir($path);
        if (is_array($files)) {
            $file_array = [];
            foreach ($files as $file) {
                if ($file->isValid()) {
                    $ext = $file->getClientOriginalExtension() ?: $file->guessExtension();
                    $newName = Str::uuid().'.'.$ext;
                    $file->storeAs($dir, $newName);
                    $file_array[] = 'storage/'.$dir.'/'.$newName;
                }
            }

            return $file_array;
        } elseif ($request->hasFile($source) && ! is_array($files)) {
            $file = $request->file($source);
            if ($file->isValid()) {
                $ext = $file->getClientOriginalExtension() ?: $file->guessExtension();
                $newName = Str::uuid().'.'.$ext;
                $file->storeAs($dir, $newName);

                return 'storage/'.$dir.'/'.$newName;
            }
        }

        return 'default.png';
    }
}

if (! function_exists('loadFile')) {
    function loadFile($path, $default = 'default.png')
    {
        if (empty($path)) {
            return asset($default);
        }

        if (filter_var($path, FILTER_VALIDATE_URL)) {
            return $path;
        }

        // Remove 'storage/' prefix if present
        $path = str_replace('storage/', '', $path);

        // Check if file exists in storage
        if (! empty($path) && Storage::disk('public')->exists($path)) {
            return asset('storage/'.$path);
        }

        // Check if file exists in public path
        if (! empty($path) && file_exists(public_path($path))) {
            return asset($path);
        }

        return asset($default);
    }
}

if (! function_exists('removeFile')) {
    function removeFile($path)
    {
        $is_detect = strpos($path, 'default.png') === false ? true : false;

        return ($is_detect && file_exists($path) && is_file($path) && ! is_dir($path)) ? @unlink($path) : false;
    }
}

if (! function_exists('checkDir')) {
    function checkDir($path)
    {
        $dir = storage_path('app/public/'.date('Y').'/'.date('m').'/'.$path);
        if (! is_dir($dir)) {
            mkdir($dir, 0777, true);
        }

        return date('Y').'/'.date('m').'/'.$path;
    }
}

if (! function_exists('copyFile')) {
    function copyFile($path, $target = 'avatars')
    {
        $is_detect = strpos($path, 'default.png') === false ? true : false;
        checkDir($target);
        $from = public_path($path);
        $target = str_replace('tempfilez', $target, $path);
        if ($is_detect && file_exists($from) && is_file($from) && ! is_dir($from)) {
            File::copy($from, public_path($target));

            return $target;
        }

        return false;
    }
}

if (! function_exists('website')) {
    function website($key = 'logo')
    {
        $settings = cache()->rememberForever('website_settings', function () {
            $setting = DB::table('settings')->where('user_id', 1)->get();

            return $setting->keyBy('key');
        });
        if ($key == 'logo') {
            $app_theme = $settings->get('app_theme')->value;
            if ($app_theme == 'dark') {
                return asset($settings->get('app_light_logo')->value);
            }

            return asset($settings->get('app_dark_logo')->value);
        } elseif ($key == 'favicon') {
            return asset($settings->get('favicon')->value);
        } else {
            return $settings->get($key)->value;
        }

        return false;
    }
}
if (! function_exists('theme')) {
    function theme()
    {
        return 'web';
        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $is_detect = preg_match("/(android|avantgo|blackberry|iphone|ipod|ipad|bolt|boost|cricket|docomo |fone|hiptop|opera mini|mini|kitkat|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER['HTTP_USER_AGENT']);
            if ($is_detect) {
                return 'phone';
            }
        }

        return 'web';
    }
}

if (! function_exists('logo')) {
    function logo()
    {
        if (setting('app_theme') && setting('app_theme') == 'light') {
            return asset(setting('app_dark_logo'));
        }

        return asset(setting('app_light_logo'));
    }
}

if (! function_exists('isRoute')) {
    function isRoute($route)
    {
        return request()->routeIs($route) ? 'sidebar-active' : '';
    }
}
if (! function_exists('activeNav')) {
    function activeNav($route)
    {
        if (is_array($route)) {
            $rt = '';
            foreach ($route as $rut) {
                $rt .= request()->routeIs($rut) || '';
            }

            return $rt ? ' active current ' : '';
        }

        return request()->routeIs($route) ? ' active current ' : '';
    }
}
if (! function_exists('toggleNav')) {
    function toggleNav(string|array $route)
    {
        if (is_array($route)) {
            $rt = '';
            foreach ($route as $rut) {
                $rt .= request()->routeIs($rut) || '';
            }

            return $rt ? 'block' : 'none';
        }

        return request()->routeIs($route) ? 'block' : 'none';
    }
}
if (! function_exists('svgStar')) {
    function svgStar($fill = '4285f4')
    {
        return '<span class="pl-1"><img title="Ainjibi Verified" alt="Ainjibi Verified" style="height: 22px;vertical-align: middle; margin-bottom:2px;cursor:pointer;width: 22px;" src="'.asset('frontend/assets/img/svg/verified.svg').'"></span>';
    }
}

if (! function_exists('userName')) {
    function userName($user)
    {
        if ($user->company_name) {
            if ($user->blue_badge) {
                return ucfirst($user->company_name).' '.svgStar();
            }

            return ucfirst($user->company_name);
        }

        return ucfirst($user->fullname);
    }
}
if (! function_exists('makeBackEndDate')) {
    function makeBackEndDate($date)
    {
        return Carbon::createFromFormat('d/m/Y', $date);
    }
}
if (! function_exists('parseDate')) {
    function parseDate($date)
    {
        return Carbon::parse($date);
    }
}
if (! function_exists('parseTime')) {
    function parseTime($time)
    {
        return Carbon::parse($time)->format('H:i');
    }
}
if (! function_exists('makeFrontEndDate')) {
    function makeFrontEndDate($date)
    {
        return Carbon::createFromFormat('Y-m-d', $date);
    }
}

if (! function_exists('panel')) {
    function panel($val)
    {
        return config('panel.'.$val);
    }
}
if (! function_exists('ainjibi')) {
    function ainjibi($val)
    {
        return config('ainjibi.'.$val);
    }
}

if (! function_exists('roleName')) {
    function roleName($roles)
    {
        $r = '';
        foreach ($roles->where('name', '!=', 'client') as $role) {
            $r .= '<span class="badge badge-info">'.ucfirst(explode('@uid', $role->name)[0]).'</span>';
        }

        return $r;
    }
}
if (! function_exists('trimRoleAdmin')) {
    function trimRoleAdmin($roles)
    {
        return str_replace('-', ' ', $roles);
    }
}
if (! function_exists('trimRole')) {
    function trimRole($val)
    {
        return str_replace('-', ' ', explode('@uid', $val)[0]);
    }
}

if (! function_exists('userStatus')) {
    function userStatus($status)
    {
        switch ($status) {
            case 'active':
                return '<span class="badge badge-success">Active</span>';
                break;
            case 'pending':
                return '<span class="badge badge-warning">Pending</span>';
                break;
            case 'remove':
                return '<span class="badge" style="background-color: #fa5661;color:#fff;">Remove</span>';
                break;
            case 'mute':
                return '<span class="badge badge-info">Mute</span>';
                break;
            default:
                return '<span class="badge badge-danger">Suspend</span>';
                break;
        }
    }
}
if (! function_exists('selectStatus')) {
    function selectStatus($value = '')
    {
        return '
            <option value="active" '.($value == 'active' ? 'selected' : '').'>Active</option>
            <option value="pending" '.($value == 'pending' ? 'selected' : '').'>Pending</option>
            <option value="remove" '.($value == 'remove' ? 'selected' : '').'>Remove</option>
            <option value="mute" '.($value == 'mute' ? 'selected' : '').'>Mute</option>
            <option value="suspend" '.($value == 'suspend' ? 'selected' : '').'>Suspend</option>';
    }
}

if (! function_exists('sakkhat')) {
    function sakkhat($key = null)
    {
        return config('sakkhat.'.$key);
    }
}
if (! function_exists('uniqueId')) {
    function uniqueId($lenght = 8)
    {
        if (function_exists('random_bytes')) {
            $bytes = random_bytes(ceil($lenght / 2));
        } elseif (function_exists('openssl_random_pseudo_bytes')) {
            $bytes = openssl_random_pseudo_bytes(ceil($lenght / 2));
        } else {
            throw new \Exception('no cryptographically secure random function available');
        }

        return strtoupper(substr(bin2hex($bytes), 0, $lenght));
    }
}

if (! function_exists('unique_int')) {
    function unique_int($lenght = 6, $pad = '0')
    {
        return str_pad(random_int(0, 999999), $lenght, $pad, STR_PAD_LEFT);
    }
}

if (! function_exists('errorProcessor')) {
    function errorProcessor($validator)
    {
        $err_keeper = [];
        foreach ($validator->errors()->getMessages() as $index => $error) {
            array_push($err_keeper, ['code' => $index, 'message' => $error[0]]);
        }

        return $err_keeper;
    }
}

if (! function_exists('propic')) {
    function propic($user)
    {
        return $user->avatar ? asset($user->avatar) : asset('assist/images/avatar.png');
    }
}
if (! function_exists('user')) {
    function user()
    {
        return auth()->user();
    }
}

if (! function_exists('owner_id')) {
    function owner_id()
    {
        $my_id = user()->id;
        $dependency = AuthorizationDependency::where('user_id', $my_id)->where('status', 'active')->where('is_login', 1)->first();
        if (! $dependency) {
            abort(404);
        }

        return $dependency->owner_id;
    }
}

if (! function_exists('slug')) {
    function slug($slug)
    {
        return Str::slug($slug);
    }
}

if (! function_exists('word_limit')) {
    function word_limit($string = '', int $limit = 8)
    {
        if (empty($string) || $string == null) {
            return '';
        }

        return Str::words(strip_tags($string), $limit);
    }
}

if (! function_exists('assignRoles')) {
    function assignRoles(User $user, array $roles = ['regular'])
    {
        $priority = ['admin', 'moderator_of_admin', 'vendor', 'moderator_of_vendor', 'regular', 'public'];
        $levels = AuthorizationLevel::whereIn('type', $roles)->whereFlag('default')->get();
        $defaultLevel = null;
        foreach ($priority as $role) {
            foreach ($levels as $level) {
                if ($level->type === $role) {
                    $defaultLevel = $level;
                    break 2;
                }
            }
        }
        foreach ($levels as $level) {
            $isDefault = ($defaultLevel && $level->id === $defaultLevel->id) ? 1 : 0;
            AuthorizationDependency::updateOrCreate([
                'user_id' => $user->id,
                'level_id' => $level->id,
            ], [
                'subject_type' => 'user',
                'owner_id' => $user->id,
                'subject_id' => $user->id,
                'type' => $level->type,
                'is_default' => $isDefault,
                'is_login' => $isDefault,
                'joining_at' => now(),
            ]);
        }
    }
}

if (! function_exists('userHasPrivilege')) {
    function userHasPrivilege(array $permission)
    {
        if (AuthorizationChecker::canDo($permission)) {
            return true;
        }

        return false;
    }
}
if (! function_exists('userPrivilegeParams')) {
    function userPrivilegeParams(string $permission)
    {
        if (AuthorizationChecker::canDo([$permission])) {
            return AuthorizationChecker::getParams($permission);
        }

        return false;
    }
}

if (! function_exists('loginDependency')) {
    function loginDependency($reset = false)
    {
        if (auth()->check()) {
            if ($reset) {
                cache()->forget(auth()->id().'-userLoginCacheDependency');
            }
            $authLoginependency = cache()->rememberForever(auth()->id().'-userLoginCacheDependency', function () {
                return AuthorizationDependency::where('user_id', auth()->id())->where('status', 'active')->where('is_login', 1)->first();
            });
            if ($authLoginependency) {
                return $authLoginependency;
            }
        }

        return false;
    }
}
if (! function_exists('owner')) {
    function owner()
    {
        if (auth()->check()) {
            $username = user()->username;
            $ownerId = loginDependency()->owner_id;

            return Cache::rememberForever($username.'_'.$ownerId, function () use ($ownerId) {
                return User::find($ownerId);
            });
        }

        return false;
    }
}

if (! function_exists('creatPermission')) {
    function creatPermission($level_id, $module, $name, $value, $params = null, $removable = 0)
    {
        return ['level_id' => $level_id, 'module' => $module, 'name' => $name, 'value' => $value, 'params' => $params, 'removable' => $removable];
    }
}
if (! function_exists('bn_slug')) {
    function bn_slug($text, $separator = '-')
    {
        $array = ['।', 'ঃ', '৳', '`', '~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '-', '=', '+', ';', ':', "'", '"', '|', '\\', ',', '<', '.', '>', '´', '’', '¢', '«', '»', '©', '†', '°', '÷', '[[', ']]', '…', '—', '–', '€', '≥', '≤', '–', '×', '≠', '¶', '±', '‘', '’', '“', '”', '®', '§', '™', '♪', '♫', '♥', 'π', '≈', '/', '?'];
        $slug = strtolower(str_replace($array, '', trim($text)));

        return preg_replace('/-{2,}/', $separator, str_replace(' ', $separator, $slug));
        // return strtolower(preg_replace('/\s+/u', '-', trim($text)));
    }
}
if (! function_exists('gtran')) {
    function gtran($text, $to = null)
    {
        $to = $to ?? app()->getLocale();

        return GoogleTranslate::trans($text, $to);
    }
}

if (! function_exists('make_slug')) {
    function make_slug($string)
    {
        $slug = preg_replace('/\s+/u', '-', trim($string));
        $slug = str_replace('/', '', $slug);
        $slug = str_replace('?', '', $slug);

        return mb_strtolower($slug, 'UTF-8');
    }
}
if (! function_exists('getHref')) {
    function getHref($link)
    {
        $href = '#';

        if ($link['type'] == 'home') {
            $href = route('home');
        } elseif ($link['type'] == 'profiles') {
            $href = route('home');
        } elseif ($link['type'] == 'pricing') {
            $href = route('home');
        } elseif ($link['type'] == 'faq') {
            $href = route('home');
        } elseif ($link['type'] == 'blogs') {
            $href = route('home');
        } elseif ($link['type'] == 'contact') {
            $href = route('home');
        } elseif ($link['type'] == 'custom') {
            if (empty($link['href'])) {
                $href = '#';
            } else {
                $href = $link['href'];
            }
        } else {
            $pageid = (int) $link['type'];
            $page = Page::find($pageid);
            if (! empty($page)) {
                $href = route('front.dynamicPage', [$page->slug]);
            } else {
                $href = '#';
            }
        }

        return $href;
    }
}
if (! function_exists('niceNumber')) {
    function niceNumber($n)
    {
        // first strip any formatting;
        $n = (0 + str_replace(',', '', $n));

        // is this a number?
        if (! is_numeric($n)) {
            return $n;
        }

        // now filter it;
        if ($n >= 1000000000000) {
            return round(($n / 1000000000000), 1).' T';
        } elseif ($n >= 1000000000) {
            return round(($n / 1000000000), 1).' B';
        } elseif ($n >= 1000000) {
            return round(($n / 1000000), 1).' M';
        } elseif ($n >= 1000) {
            return round(($n / 1000), 1).' K';
        }

        return number_format($n);
    }
}

if (! function_exists('niceFileSize')) {
    function niceFileSize($bytes, $withOutUnit = false)
    {
        $result = '';
        $bytes = floatval($bytes);
        $arBytes = [
            0 => [
                'UNIT' => 'TB',
                'VALUE' => pow(1024, 4),
            ],
            1 => [
                'UNIT' => 'GB',
                'VALUE' => pow(1024, 3),
            ],
            2 => [
                'UNIT' => 'MB',
                'VALUE' => pow(1024, 2),
            ],
            3 => [
                'UNIT' => 'KB',
                'VALUE' => 1024,
            ],
            4 => [
                'UNIT' => 'B',
                'VALUE' => 1,
            ],
        ];

        foreach ($arBytes as $arItem) {
            if ($bytes >= $arItem['VALUE']) {
                $result = $bytes / $arItem['VALUE'];
                if ($withOutUnit) {
                    $result = round($result, 2);
                } else {
                    $result = strval(round($result, 2)).' '.$arItem['UNIT'];
                }
                break;
            }
        }

        return $result;
    }
}

if (! function_exists('hex2rgb')) {
    function hex2rgb($colour)
    {
        if ($colour[0] == '#') {
            $colour = substr($colour, 1);
        }
        if (strlen($colour) == 6) {
            [$r, $g, $b] = [$colour[0].$colour[1], $colour[2].$colour[3], $colour[4].$colour[5]];
        } elseif (strlen($colour) == 3) {
            [$r, $g, $b] = [$colour[0].$colour[0], $colour[1].$colour[1], $colour[2].$colour[2]];
        } else {
            return false;
        }
        $r = hexdec($r);
        $g = hexdec($g);
        $b = hexdec($b);

        return ['red' => $r, 'green' => $g, 'blue' => $b];
    }
}

if (! function_exists('seoTool')) {
    function seoTool($title = null, $description = null, $keywords = null, $ogimage = null)
    {
        SEOTools::setTitle($title ?? setting('slogan'));
        SEOTools::setDescription($description ?? setting('app_description'));
        SEOTools::setCanonical(url()->current());
        SEOTools::twitter()->setTitle(url()->current());
        SEOTools::twitter()->setSite('@bangali');
        SEOMeta::addKeyword($keywords ?? setting('app_keyword'));
        OpenGraph::setUrl(url()->current());
        OpenGraph::addProperty('type', 'articles');
        OpenGraph::addImage($ogimage ?? setting('ogimage'));
        OpenGraph::setDescription($description ?? setting('app_description'));
        SEOTools::jsonLd()->addImage($ogimage ?? setting('ogimage'));
    }
}
if (! function_exists('get_cpu_uses')) {
    function get_cpu_uses()
    {
        $load = sys_getloadavg();

        return $load[0];
    }
}
if (! function_exists('getSystemMemInfo')) {
    function getSystemMemInfo()
    {
        $data = explode("\n", file_get_contents('/proc/meminfo'));
        $meminfo = [];
        foreach ($data as $line) {
            @[$key, $val] = explode(':', $line);
            $meminfo[$key] = trim($val);
        }

        return $meminfo;
    }
}

if (! function_exists('get_memory_usage')) {
    function get_memory_usage()
    {
        $free = shell_exec('free');
        $free = (string) trim($free);
        $free_arr = explode("\n", $free);
        $mem = explode(' ', $free_arr[1]);
        $mem = array_filter($mem);
        $mem = array_merge($mem);
        $memory_usage = $mem[2] / $mem[1] * 100;

        return $memory_usage;
    }
}
// Get Ads from DB

if (! function_exists('getAds')) {
    function getAds($page, $position, $source)
    {
        return optional(Advertisement::where('status', 1)
            ->where('page', $page)
            ->where('position', $position)
            ->where('source', $source)->first())->script;
    }
}

if (! function_exists('getRgb')) {
    function getRgb($hex)
    {
        return sscanf($hex, '#%02x%02x%02x');
    }
}

// POINT SYSTEM FUNCTIONS

if (! function_exists('badgeName')) {
    function badgeName($badge)
    {
        if ($badge->image) {
            return '<img src="'.asset($badge->image).'" alt="'.$badge->name.'" class="img-fluid img-responsive img">';
        }
        $a = getRgb($badge->color);
        $rgb = 'rgb('.$a[2].','.$a[1].','.$a[0].')';

        return '<span class="badge p-3 text-light" style="background: linear-gradient(90deg, '.$badge->color.', '.$rgb.')"><i class="fa '.$badge->icon.' pr-1"></i>'.$badge->name.'</span>';
    }
}
if (! function_exists('checkValue')) {
    function checkValue($array, $name)
    {
        return array_key_exists($name, $array) ? $array[$name] : '';
    }
}

if (! function_exists('assignPoint')) {
    function assignPoint($user_id = null, $name = null, $action = null, $action_id = null)
    {
        $type = explode('_', $name)[0];
        $start = now()->format('Y-m-d').' 00:00:00';
        $end = now()->format('Y-m-d').' 23:59:59';
        $user = User::find($user_id);
        $level_id = $user->getDefaultLevel->level_id;

        $earnCredit = AuthorizationPermission::where('level_id', $level_id)
            ->where('module', 'like', 'credit%')
            ->pluck('value', 'name')->toArray();
        $todayTotal = PointTransaction::where('user_id', $user_id)
            ->where('created_at', '>=', $start)
            ->where('created_at', '<=', $end)->sum('point');
        $totalByName = PointTransaction::where('user_id', $user_id)
            ->where('created_at', '>=', $start)
            ->where('created_at', '<=', $end)
            ->where('point_of', $name)->sum('point');
        $chkPointName = PointTransaction::where('user_id', $user_id)
            ->where('point_of', 'like', "$type%")
            ->where('action_id', $action_id)->first();
        $assigns = PointSettings::where('name', 'like', "$type%")
            ->pluck('value', 'name')->toArray();

        if (
            $earnCredit['allow'] == 1 &&
            $earnCredit['limit'] > $todayTotal &&
            $totalByName < $assigns[$type.'_maxday'] &&
            ! $chkPointName
        ) {
            PointTransaction::create([
                'user_id' => $user_id,
                'action' => $action,
                'action_id' => $action_id,
                'point_of' => $name,
                'point' => $assigns[$name],
            ]);
        }
        $userTotalPoint = PointTransaction::where('user_id', $user_id)->sum('point');
        UserPoint::updateOrCreate([
            'user_id' => $user_id,
        ], [
            'user_id' => $user_id,
            'point' => $userTotalPoint,
        ]);
    }
}

if (! function_exists('getIpInfo')) {
    // moveable
    function getIpInfo()
    {
        $ip = null;
        $deep_detect = true;

        if (filter_var($ip, FILTER_VALIDATE_IP) === false) {
            $ip = $_SERVER['REMOTE_ADDR'];
            if ($deep_detect) {
                if (filter_var(@$_SERVER['HTTP_X_FORWARDED_FOR'], FILTER_VALIDATE_IP)) {
                    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
                }
                if (filter_var(@$_SERVER['HTTP_CLIENT_IP'], FILTER_VALIDATE_IP)) {
                    $ip = $_SERVER['HTTP_CLIENT_IP'];
                }
            }
        }

        $xml = @simplexml_load_file('http://www.geoplugin.net/xml.gp?ip='.$ip);

        $country = @$xml->geoplugin_countryName;
        $city = @$xml->geoplugin_city;
        $area = @$xml->geoplugin_areaCode;
        $code = @$xml->geoplugin_countryCode;
        $long = @$xml->geoplugin_longitude;
        $lat = @$xml->geoplugin_latitude;

        $data['country'] = $country ?? null;
        $data['city'] = $city;
        $data['area'] = $area;
        $data['code'] = $code;
        $data['long'] = $long;
        $data['lat'] = $lat;
        $data['ip'] = request()->ip();
        $data['time'] = date('d-m-Y h:i:s A');

        return $data;
    }
}
if (! function_exists('osBrowser')) {
    // moveable
    function osBrowser()
    {
        $user_agent = $_SERVER['HTTP_USER_AGENT'];
        $os_platform = 'Unknown OS Platform';
        $os_array = [
            '/windows nt 10/i' => 'Windows 10',
            '/windows nt 6.3/i' => 'Windows 8.1',
            '/windows nt 6.2/i' => 'Windows 8',
            '/windows nt 6.1/i' => 'Windows 7',
            '/windows nt 6.0/i' => 'Windows Vista',
            '/windows nt 5.2/i' => 'Windows Server 2003/XP x64',
            '/windows nt 5.1/i' => 'Windows XP',
            '/windows xp/i' => 'Windows XP',
            '/windows nt 5.0/i' => 'Windows 2000',
            '/windows me/i' => 'Windows ME',
            '/win98/i' => 'Windows 98',
            '/win95/i' => 'Windows 95',
            '/win16/i' => 'Windows 3.11',
            '/macintosh|mac os x/i' => 'Mac OS X',
            '/mac_powerpc/i' => 'Mac OS 9',
            '/linux/i' => 'Linux',
            '/ubuntu/i' => 'Ubuntu',
            '/iphone/i' => 'iPhone',
            '/ipod/i' => 'iPod',
            '/ipad/i' => 'iPad',
            '/android/i' => 'Android',
            '/blackberry/i' => 'BlackBerry',
            '/webos/i' => 'Mobile',
        ];
        foreach ($os_array as $regex => $value) {
            if (preg_match($regex, $user_agent)) {
                $os_platform = $value;
            }
        }
        $browser = 'Unknown Browser';
        $browser_array = [
            '/msie/i' => 'Internet Explorer',
            '/firefox/i' => 'Firefox',
            '/safari/i' => 'Safari',
            '/chrome/i' => 'Chrome',
            '/edge/i' => 'Edge',
            '/opera/i' => 'Opera',
            '/netscape/i' => 'Netscape',
            '/maxthon/i' => 'Maxthon',
            '/konqueror/i' => 'Konqueror',
            '/mobile/i' => 'Handheld Browser',
        ];
        foreach ($browser_array as $regex => $value) {
            if (preg_match($regex, $user_agent)) {
                $browser = $value;
            }
        }

        $data['os_platform'] = $os_platform;
        $data['browser'] = $browser;

        return $data;
    }
}

if (! function_exists('cryptoQR')) {
    function cryptoQR($wallet, $amount, $crypto = null)
    {
        $varb = $wallet.'?amount='.$amount;

        return "https://chart.googleapis.com/chart?chs=300x300&cht=qr&chl=$varb&choe=UTF-8";
    }
}

// Geo Location
if (! function_exists('country')) {
    function country(): object
    {
        return cache()->rememberForever('geo-'.session()->getId().'-'.request()->ip(), function () {
            return Country::where('code', maxMind() ?? 'BD')->first();
        });
    }
}

if (! function_exists('maxMind')) {
    function maxMind()
    {
        $ip = request()->ip();
        if ($ip == '127.0.0.1') {
            $ip = '103.133.203.240'; // BD
            // $ip = "64.86.252.66"; //USA
            // $ip = "62.219.33.146"; //il
        }
        $reader = new Reader(storage_path('MaxMind/GeoLite2-Country.mmdb'));
        $record = $reader->country($ip);

        return $record->country->isoCode;
    }
}
if (! function_exists('roundToNearestMinutes')) {
    /**
     * Round a timestamp to the nearest 5 minutes.
     *
     * @param  \Carbon\Carbon  $timestamp
     * @param  int  $minutes
     * @return \Carbon\Carbon
     */
    function roundToNearestMinutes($timestamp, $minutes = 5)
    {
        $seconds = $timestamp->minute * 60 + $timestamp->second;
        $roundedSeconds = round($seconds / ($minutes * 60)) * ($minutes * 60);

        return $timestamp->copy()->startOfHour()->addSeconds($roundedSeconds);
    }
}
if (! function_exists('countries')) {
    function countries($installed = false)
    {
        if ($installed) {
            return Cache::rememberForever('countries-installed', function () {
                return Country::installed()->active()->orderBy('name')->get();
            });
        } else {
            return Cache::rememberForever('countries', function () {
                return Country::active()->orderBy('name')->get();
            });
        }
    }
}

if (! function_exists('states')) {
    function states($country_id)
    {
        $valid = Country::where('id', $country_id)->exists();
        if ($valid) {
            return Cache::rememberForever('states-'.$country_id, function () use ($country_id) {
                return State::active()->whereCountryId($country_id)->orderBy('name')->get();
            });
        }
    }
}

if (! function_exists('cities')) {
    function cities($id)
    {
        return City::whereAny(['country_id', 'state_id'], $id)->orderBy('name')->get();
    }
}
